function [ Fx ] = FrameAXXB( FaList,FbList,method )
%Solves the matrix equation Fa*Fx=Fx*Fb
% 
% Copyright (C) Russell H. Taylor 2013
% For use with CIS I only
% Do not redistribute without written permission from Russell Taylor

meth = 'Quat';
% meth = 'Axis';
if nargin > 2
    meth = method;
end

RaList = [];
RbList = []; 
M = [];
N = size(FaList,1);
for i=1:N
    % Split out R parts
    RaList = [RaList;FaList(i).R];
    RbList = [RbList;FbList(i).R];
end

Rx = RotAXXB(RaList,RbList,meth);
% Now do the p part
M = []; b = [];
for i=1:N
    M = [M;RaList(i).el-eye(3)];
    bp = Rx*FbList(i).p-FaList(i).p;
    b = [b;bp.el];
end
pxel = M\b;
% pxel(isnan(pxel))=0;
Fx = Frame(Rx,vct3(pxel));
end

